/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.whatsnew.internal.xwikiblog;

import com.apptasticsoftware.rssreader.Enclosure;
import com.apptasticsoftware.rssreader.Item;
import com.apptasticsoftware.rssreader.RssReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class XWikiBlogRSSReader {
    private static final String XWIKI_ITEM_IMAGE_TAG = "xwiki:image";
    private static final String USER_AGENT = "XWikiWhatsNew";

    public Stream<Item> read(String rssURL) throws IOException {
        RssReader rssReader = this.createRssReader();
        return rssReader.read(rssURL);
    }

    public Stream<Item> read(InputStream rssStream) {
        RssReader rssReader = this.createRssReader();
        return rssReader.read(rssStream);
    }

    private RssReader createRssReader() {
        RssReader rssReader = new RssReader();
        this.addXWikiDublinCoreSupport(rssReader);
        rssReader.setUserAgent(USER_AGENT);
        return rssReader;
    }

    private void addXWikiDublinCoreSupport(RssReader rssReader) {
        rssReader.addItemExtension("dc:subject", (item, categoryString) -> {
            for (String singleCategory : StringUtils.split((String)categoryString, (String)",")) {
                item.addCategory(singleCategory.trim());
            }
        });
        rssReader.addItemExtension("dc:creator", Item::setAuthor);
        rssReader.addItemExtension("dc:date", Item::setPubDate);
        rssReader.addItemExtension(XWIKI_ITEM_IMAGE_TAG, (item, image) -> this.getEnclosure((Item)item).setUrl(image));
        rssReader.addItemExtension(XWIKI_ITEM_IMAGE_TAG, "type", (item, type) -> this.getEnclosure((Item)item).setType(type));
        rssReader.addItemExtension(XWIKI_ITEM_IMAGE_TAG, "length", (item, length) -> this.getEnclosure((Item)item).setLength(Long.valueOf(length)));
    }

    private Enclosure getEnclosure(Item item) {
        Enclosure result;
        Optional optionalEnclosure = item.getEnclosure();
        if (!optionalEnclosure.isPresent()) {
            result = new Enclosure();
            item.setEnclosure(result);
        } else {
            result = (Enclosure)optionalEnclosure.get();
        }
        return result;
    }
}

