/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.whatsnew.internal.xwikiblog;

import com.apptasticsoftware.rssreader.Enclosure;
import com.apptasticsoftware.rssreader.Item;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.extension.version.Version;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.user.UserReference;
import org.xwiki.whatsnew.NewsCategory;
import org.xwiki.whatsnew.NewsContent;
import org.xwiki.whatsnew.NewsException;
import org.xwiki.whatsnew.NewsSource;
import org.xwiki.whatsnew.NewsSourceItem;
import org.xwiki.whatsnew.internal.DefaultNewsContent;
import org.xwiki.whatsnew.internal.DefaultNewsSourceItem;
import org.xwiki.whatsnew.internal.xwikiblog.RSSContentCleaner;
import org.xwiki.whatsnew.internal.xwikiblog.XWikiBlogNewsCategoryConverter;
import org.xwiki.whatsnew.internal.xwikiblog.XWikiBlogRSSReader;

public class XWikiBlogNewsSource
implements NewsSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiBlogNewsSource.class);
    private static final String QUESTION_MARK = "?";
    private UserReference userReference;
    private Set<NewsCategory> wantedCategories;
    private Version targetXWikiVersion;
    private Map<String, Object> extraParameters;
    private int count;
    private String rssURL;
    private InputStream rssStream;
    private XWikiBlogNewsCategoryConverter categoriesConverter = new XWikiBlogNewsCategoryConverter();
    private RSSContentCleaner rssContentCleaner;

    public XWikiBlogNewsSource(String rssURL, RSSContentCleaner rssContentCleaner) {
        this.rssURL = rssURL;
        this.rssContentCleaner = rssContentCleaner;
    }

    public XWikiBlogNewsSource(InputStream rssStream, RSSContentCleaner rssContentCleaner) {
        this.rssStream = rssStream;
        this.rssContentCleaner = rssContentCleaner;
    }

    @Override
    public NewsSource forUser(UserReference userReference) {
        this.userReference = userReference;
        return this;
    }

    @Override
    public NewsSource forCategories(Set<NewsCategory> wantedCategories) {
        this.wantedCategories = Collections.unmodifiableSet(wantedCategories);
        return this;
    }

    @Override
    public NewsSource forXWikiVersion(Version targetXWikiVersion) {
        this.targetXWikiVersion = targetXWikiVersion;
        return this;
    }

    @Override
    public NewsSource forExtraParameters(Map<String, Object> extraParameters) {
        this.extraParameters = Collections.unmodifiableMap(extraParameters);
        return this;
    }

    @Override
    public NewsSource withCount(int count) {
        this.count = count;
        return this;
    }

    @Override
    public List<NewsSourceItem> build() throws NewsException {
        List<Item> articles;
        String computedRSSURL = this.computeRSSURL();
        LOGGER.debug("URL to gather \"What's New\" news: [{}]", (Object)computedRSSURL);
        try {
            XWikiBlogRSSReader rssReader = new XWikiBlogRSSReader();
            Stream<Item> itemStream = computedRSSURL != null ? rssReader.read(computedRSSURL) : rssReader.read(this.rssStream);
            articles = itemStream.toList();
        }
        catch (IOException e) {
            String message = String.format("Failed to read RSS for [%s]", computedRSSURL);
            throw new NewsException(message, e);
        }
        ArrayList<NewsSourceItem> newsItems = new ArrayList<NewsSourceItem>();
        for (Item item : articles) {
            DefaultNewsSourceItem newsItem = new DefaultNewsSourceItem();
            newsItem.setTitle(item.getTitle());
            newsItem.setDescription(this.getCleanedContent(item));
            newsItem.setAuthor(item.getAuthor());
            newsItem.setCategories(this.categoriesConverter.convertFromRSS(item.getCategories()));
            newsItem.setPublishedDate(this.parseDateTime(item.getPubDate()));
            newsItem.setOriginURL(item.getLink());
            newsItem.setImageURL(this.getURL(item));
            newsItems.add(newsItem);
        }
        return newsItems;
    }

    private Optional<String> getURL(Item item) {
        Optional optionalEnclosure = item.getEnclosure();
        Optional<String> optionalURL = optionalEnclosure.isEmpty() ? Optional.empty() : Optional.of(((Enclosure)optionalEnclosure.get()).getUrl());
        return optionalURL;
    }

    private Optional<NewsContent> getCleanedContent(Item item) {
        Optional optionalDescription = item.getDescription();
        Optional<NewsContent> optionalContent = optionalDescription.isPresent() ? Optional.of(new DefaultNewsContent(this.rssContentCleaner.clean((String)optionalDescription.get()), this.getContentSyntax())) : Optional.empty();
        return optionalContent;
    }

    private Syntax getContentSyntax() {
        return Syntax.HTML_5_0;
    }

    private String computeRSSURL() {
        String result = this.rssURL == null ? null : (this.wantedCategories == null ? this.rssURL : String.format("%s%s%s", this.rssURL, this.rssURL.contains(QUESTION_MARK) ? "&" : QUESTION_MARK, this.categoriesConverter.convertToQueryString(this.wantedCategories)));
        return result;
    }

    public String toString() {
        return String.format("XWiki Blog news source for URL [%s]", this.rssURL);
    }

    private Optional<Date> parseDateTime(Optional<String> dateAsString) {
        Optional<Date> result;
        if (!dateAsString.isPresent()) {
            result = Optional.empty();
        } else {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'hh:mm:ssZ");
            DateTime dt = formatter.parseDateTime(dateAsString.get());
            result = Optional.of(dt.toDate());
        }
        return result;
    }
}

