/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.whatsnew.internal;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.whatsnew.NewsCategory;

@Component
@Singleton
public class CategoriesConverter
extends AbstractConverter<Set<NewsCategory>> {
    protected Set<NewsCategory> convertToType(Type targetType, Object value) {
        if (value == null) {
            return Collections.emptySet();
        }
        if (value instanceof Set) {
            return (Set)value;
        }
        LinkedHashSet<NewsCategory> categories = new LinkedHashSet<NewsCategory>();
        String categoriesString = value.toString();
        for (String categoryString : StringUtils.split((String)categoriesString, (String)", ")) {
            if (NewsCategory.ADMIN_USER.toString().equalsIgnoreCase(categoryString)) {
                categories.add(NewsCategory.ADMIN_USER);
                continue;
            }
            if (NewsCategory.SIMPLE_USER.toString().equalsIgnoreCase(categoryString)) {
                categories.add(NewsCategory.SIMPLE_USER);
                continue;
            }
            if (NewsCategory.ADVANCED_USER.toString().equalsIgnoreCase(categoryString)) {
                categories.add(NewsCategory.ADVANCED_USER);
                continue;
            }
            if (NewsCategory.EXTENSION.toString().equalsIgnoreCase(categoryString)) {
                categories.add(NewsCategory.EXTENSION);
                continue;
            }
            categories.add(NewsCategory.UNKNOWN);
        }
        return categories;
    }
}

