/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.ui;

import com.xpn.xwiki.XWikiContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.internal.RequiredRightChangeSuggestion;
import org.xwiki.platform.security.requiredrights.internal.RequiredRightsChangeSuggestionManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BulletedListBlock;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRightsManager;
import org.xwiki.skinx.SkinExtension;
import org.xwiki.uiextension.UIExtension;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserType;

@Component
@Named(value="org.xwiki.platform.security.requiredrights.ui.RequiredRightsInfoUIExtension")
@Singleton
public class RequiredRightsInfoUIExtension
implements UIExtension {
    public static final String ROLE_HINT = "org.xwiki.platform.security.requiredrights.ui.RequiredRightsInfoUIExtension";
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private RequiredRightsChangeSuggestionManager suggestionManager;
    @Inject
    @Named(value="withTranslations")
    private RequiredRightAnalyzer<DocumentReference> requiredRightAnalyzer;
    @Inject
    private DocumentRequiredRightsManager documentRequiredRightsManager;
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="jsrx")
    private SkinExtension jsrx;
    @Inject
    @Named(value="ssrx")
    private SkinExtension ssrx;
    @Inject
    private UserPropertiesResolver userPropertiesResolver;

    public Block execute() {
        XWikiContext xWikiContext = (XWikiContext)this.contextProvider.get();
        DocumentReference documentReference = xWikiContext.getDoc().getDocumentReference();
        DocumentReference userReference = xWikiContext.getUserReference();
        try {
            Optional requiredRightsOptional = this.documentRequiredRightsManager.getRequiredRights(documentReference);
            if (requiredRightsOptional.isPresent()) {
                boolean isAdvanced;
                this.jsrx.use("js/security/requiredrights/requiredRightsInformationUpdater.js");
                ArrayList<Object> results = new ArrayList<Object>();
                results.add(new RawBlock("<dt><label>", Syntax.HTML_5_0));
                results.add(this.localizationManager.getTranslation("security.requiredrights.ui.informationLabel").render(new Object[0]));
                results.add(new RawBlock("</label></dt><dd class=\"required-rights-information\">", Syntax.HTML_5_0));
                DocumentRequiredRights requiredRights = (DocumentRequiredRights)requiredRightsOptional.get();
                results.addAll(this.getCurrentRequiredrightsDisplay(requiredRights));
                boolean bl = isAdvanced = this.userPropertiesResolver.resolve((UserReference)CurrentUserReference.INSTANCE, new Object[0]).getType() == UserType.ADVANCED;
                if (this.authorizationManager.hasAccess(Right.EDIT, userReference, (EntityReference)documentReference) && (isAdvanced || this.authorizationManager.hasAccess(Right.SCRIPT, userReference, (EntityReference)documentReference))) {
                    if (!requiredRights.enforce()) {
                        results.add(this.getTranslatedParagraph("security.requiredrights.ui.suggestEnforcing"));
                    } else {
                        Optional<RequiredRightChangeSuggestion> suggestedOperationOptional = this.getSuggestedOperation(xWikiContext);
                        suggestedOperationOptional.flatMap(suggestedOperation -> this.getSuggestionDisplay((RequiredRightChangeSuggestion)suggestedOperation, userReference, documentReference)).ifPresent(results::add);
                    }
                    this.jsrx.use("js/security/requiredrights/requiredRightsDialog.js");
                    this.ssrx.use("css/security/requiredrights/requiredRightsDialog.css");
                    results.add(new RawBlock("<button type=\"button\" class=\"btn btn-default\" disabled data-xwiki-requiredrights-dialog=\"show\">", Syntax.HTML_5_0));
                    results.add(this.localizationManager.getTranslation("security.requiredrights.ui.reviewRequiredRightsButton").render(new Object[0]));
                    results.add(new RawBlock("</button>", Syntax.HTML_5_0));
                }
                results.add(new RawBlock("</dd>", Syntax.HTML_5_0));
                return new CompositeBlock(results);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error getting required rights for document [{}], root cause: [{}]", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return new CompositeBlock();
    }

    private Optional<Block> getSuggestionDisplay(RequiredRightChangeSuggestion suggestedOperation, DocumentReference userReference, DocumentReference documentReference) {
        Optional<Block> suggestionDisplay = Optional.empty();
        if (suggestedOperation.increasesRights() && this.authorizationManager.hasAccess(suggestedOperation.rightToAdd().right(), userReference, documentReference.extractReference(suggestedOperation.rightToAdd().scope()))) {
            suggestionDisplay = suggestedOperation.requiresManualReview() ? Optional.of(this.getTranslatedParagraph("security.requiredrights.ui.maybeMissingRequiredRight")) : Optional.of(this.getTranslatedParagraph("security.requiredrights.ui.missingRequiredRightsWarning"));
        } else if (!suggestedOperation.increasesRights()) {
            suggestionDisplay = suggestedOperation.requiresManualReview() ? Optional.of(this.getTranslatedParagraph("security.requiredrights.ui.maybeTooManyRequiredRights")) : Optional.of(this.getTranslatedParagraph("security.requiredrights.ui.tooManyRequiredRights"));
        }
        return suggestionDisplay;
    }

    private List<Block> getCurrentRequiredrightsDisplay(DocumentRequiredRights requiredRights) {
        List<Object> currentRequiredRights = !requiredRights.enforce() ? List.of(this.getTranslatedParagraph("security.requiredrights.ui.notEnforced")) : (requiredRights.rights().isEmpty() ? List.of(this.getTranslatedParagraph("security.requiredrights.ui.enforcedNoRight")) : List.of(this.getTranslatedParagraph("security.requiredrights.ui.enforced"), new BulletedListBlock(requiredRights.rights().stream().map(right -> new ListItemBlock(List.of(Optional.ofNullable(this.localizationManager.getTranslation("security.requiredrights.ui.right." + String.valueOf(right.right()))).map(rec$ -> ((Translation)rec$).render(new Object[0])).orElse((Block)new WordBlock(right.right().toString()))))).toList())));
        return currentRequiredRights;
    }

    private ParagraphBlock getTranslatedParagraph(String key) {
        return new ParagraphBlock(List.of(this.localizationManager.getTranslation(key).render(new Object[0])));
    }

    private Optional<RequiredRightChangeSuggestion> getSuggestedOperation(XWikiContext context) {
        DocumentReference documentReference = context.getDoc().getDocumentReference();
        Optional<RequiredRightChangeSuggestion> result = Optional.empty();
        try {
            Optional requiredRights = this.documentRequiredRightsManager.getRequiredRights(documentReference);
            if (requiredRights.isPresent()) {
                List analysisResults = this.requiredRightAnalyzer.analyze((Object)documentReference);
                List suggestedOperations = this.suggestionManager.getSuggestedOperations(documentReference, (DocumentRequiredRights)requiredRights.get(), analysisResults);
                for (RequiredRightChangeSuggestion suggestedOperation : suggestedOperations) {
                    if (result.isEmpty() || !result.get().increasesRights() && suggestedOperation.increasesRights()) {
                        result = Optional.of(suggestedOperation);
                        continue;
                    }
                    if (result.get().increasesRights() != suggestedOperation.increasesRights() || !result.get().requiresManualReview() || suggestedOperation.requiresManualReview()) continue;
                    result = Optional.of(suggestedOperation);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Error getting or analyzing required rights for document [{}], root cause: [{}]", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return result;
    }

    public String getExtensionPointId() {
        return "org.xwiki.platform.template.information";
    }

    public String getId() {
        return ROLE_HINT;
    }

    public Map<String, String> getParameters() {
        return Map.of("order", "600");
    }
}

