/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.rest.internal;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.internal.document.DocumentRequiredRightsReader;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.requiredrights.rest.model.jaxb.DocumentRequiredRights;

@Component(roles={DocumentRequiredRightsUpdater.class})
@Singleton
public class DocumentRequiredRightsUpdater {
    @Inject
    private DocumentRequiredRightsReader documentRequiredRightsReader;
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private ModelContext modelContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRequiredRights(DocumentRequiredRights documentRequiredRights, Document doc) throws XWikiException {
        EntityReference currentEntityReference = this.modelContext.getCurrentEntityReference();
        try {
            this.modelContext.setCurrentEntityReference((EntityReference)doc.getDocumentReference());
            boolean modified = false;
            if (documentRequiredRights.isEnforce() != doc.isEnforceRequiredRights()) {
                doc.setEnforceRequiredRights(documentRequiredRights.isEnforce());
                modified = true;
            }
            if (documentRequiredRights.isEnforce()) {
                modified |= this.updateRequiredRightObjects(documentRequiredRights, doc);
            }
            if (modified) {
                doc.save(this.localizationManager.getTranslationPlain("security.requiredrights.rest.saveSummary", new java.lang.Object[0]));
            }
        }
        finally {
            this.modelContext.setCurrentEntityReference(currentEntityReference);
        }
    }

    private boolean updateRequiredRightObjects(DocumentRequiredRights documentRequiredRights, Document doc) throws XWikiException {
        boolean modified = false;
        Set<String> formattedRights = this.buildFormattedRights(documentRequiredRights, doc.getDocumentReference());
        List existingObjects = doc.getObjects((EntityReference)DocumentRequiredRightsReader.CLASS_REFERENCE);
        HashSet<String> alreadyExistingRights = new HashSet<String>();
        ArrayList<Object> objectsToRemove = new ArrayList<Object>();
        for (Object object : existingObjects) {
            String existingValue = Objects.toString(object.getValue("level"), "");
            if (formattedRights.contains(existingValue)) {
                alreadyExistingRights.add(existingValue);
                continue;
            }
            objectsToRemove.add(object);
        }
        for (String formattedRight : formattedRights) {
            if (alreadyExistingRights.contains(formattedRight)) continue;
            Object object = objectsToRemove.isEmpty() ? doc.newObject((EntityReference)DocumentRequiredRightsReader.CLASS_REFERENCE) : (Object)objectsToRemove.remove(objectsToRemove.size() - 1);
            object.set("level", (java.lang.Object)formattedRight);
            modified = true;
        }
        for (Object object : objectsToRemove) {
            doc.removeObject(object);
            modified = true;
        }
        return modified;
    }

    private Set<String> buildFormattedRights(DocumentRequiredRights documentRequiredRights, DocumentReference baseDocumentReference) {
        return documentRequiredRights.getRights().stream().map(requiredRight -> {
            EntityType resolvedEmptyEntityType;
            EntityType resolvedEntityType;
            Right right = Right.toRight((String)requiredRight.getRight());
            if (right.equals(Right.ILLEGAL)) {
                throw new WebApplicationException("Illegal right " + requiredRight.getRight(), Response.Status.BAD_REQUEST);
            }
            EntityType entityType = DocumentRequiredRightsUpdater.resolveEntityType(requiredRight.getScope());
            if (entityType != EntityType.DOCUMENT && (resolvedEntityType = this.documentRequiredRightsReader.getEffectiveEntityType(right, entityType, baseDocumentReference)) == (resolvedEmptyEntityType = this.documentRequiredRightsReader.getEffectiveEntityType(right, EntityType.DOCUMENT, baseDocumentReference))) {
                entityType = EntityType.DOCUMENT;
            }
            if (entityType == null) {
                throw new WebApplicationException("Invalid scope %s for right %s".formatted(requiredRight.getScope(), requiredRight.getRight()), Response.Status.BAD_REQUEST);
            }
            return (String)(entityType == EntityType.DOCUMENT ? "" : entityType.getLowerCase() + "_") + right.getName();
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static EntityType resolveEntityType(String scope) {
        EntityType entityType = scope == null || "null".equals(scope) ? null : (StringUtils.isNotBlank((CharSequence)scope) ? EntityType.valueOf((String)scope.toUpperCase()) : EntityType.DOCUMENT);
        return entityType;
    }
}

