/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.rest.internal;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.rest.RequiredRightsRestResource;
import org.xwiki.platform.security.requiredrights.rest.internal.DocumentRequiredRightsUpdater;
import org.xwiki.platform.security.requiredrights.rest.internal.RequiredRightsObjectConverter;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRightsManager;
import org.xwiki.security.requiredrights.rest.model.jaxb.DocumentRightsAnalysisResult;

@Component
@Named(value="org.xwiki.platform.security.requiredrights.rest.internal.DefaultRequiredRightsRestResource")
public class DefaultRequiredRightsRestResource
extends XWikiResource
implements RequiredRightsRestResource {
    @Inject
    @Named(value="withTranslations")
    private RequiredRightAnalyzer<DocumentReference> requiredRightAnalyzer;
    @Inject
    private RequiredRightsObjectConverter objectConverter;
    @Inject
    private DocumentRequiredRightsManager documentRequiredRightsManager;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private DocumentRequiredRightsUpdater documentRequiredRightsUpdater;

    @Override
    public DocumentRightsAnalysisResult analyze(String spaceNames, String page, String wiki) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wiki, spaceNames, page, null, null, true, false);
            DocumentReference documentReference = documentInfo.getDocument().getDocumentReference();
            DocumentRequiredRights currentRights = (DocumentRequiredRights)this.documentRequiredRightsManager.getRequiredRights(documentReference).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
            List analysisResults = this.requiredRightAnalyzer.analyze((Object)documentReference);
            return this.objectConverter.toDocumentRightsAnalysisResult(currentRights, analysisResults, documentReference);
        }
        catch (XWikiException | AuthorizationException e) {
            throw new XWikiRestException("Failed loading document", e);
        }
        catch (RequiredRightsException e) {
            throw new XWikiRestException("Failed analyzing required rights", (Throwable)e);
        }
    }

    @Override
    public org.xwiki.security.requiredrights.rest.model.jaxb.DocumentRequiredRights updateRequiredRights(String spaceNames, String page, String wiki, org.xwiki.security.requiredrights.rest.model.jaxb.DocumentRequiredRights documentRequiredRights) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wiki, spaceNames, page, null, null, true, false);
            Document doc = documentInfo.getDocument();
            if (!this.authorization.hasAccess(Right.EDIT, (EntityReference)doc.getDocumentReference())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            this.documentRequiredRightsUpdater.updateRequiredRights(documentRequiredRights, doc);
            return this.objectConverter.convertDocumentRequiredRights((DocumentRequiredRights)this.documentRequiredRightsManager.getRequiredRights(doc.getDocumentReference()).orElseThrow(() -> new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR)));
        }
        catch (XWikiException | AuthorizationException e) {
            throw new XWikiRestException(e);
        }
    }
}

