/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.realtime.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.netflux.EntityChannelStore;
import org.xwiki.realtime.internal.RealtimeSessionManager;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.script.service.ScriptService;
import org.xwiki.sheet.SheetManager;
import org.xwiki.wysiwyg.script.WysiwygEditorScriptService;

@Component
@Singleton
public class DefaultRealtimeSessionManager
implements RealtimeSessionManager {
    private static final String EDITOR_KEY = "editor";
    private static final String WYSIWYG = "wysiwyg";
    private static final String WIKI = "wiki";
    private static final String INLINE = "inline";
    @Inject
    private Provider<XWikiContext> xwikiContextProvider;
    @Inject
    private EntityChannelStore entityChannelStore;
    @Inject
    private SheetManager sheetManager;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    @Named(value="wysiwyg")
    private ScriptService wysiwygEditorScriptService;
    @Inject
    private Container container;

    @Override
    public boolean canJoinSession(DocumentReference documentReference, Locale locale) {
        String editMode = this.getEditMode().toLowerCase();
        if (List.of(WYSIWYG, "inplace", WIKI).contains(editMode)) {
            String contentEditor = WIKI.equals(editMode) ? WIKI : WYSIWYG;
            List<String> contentChannelPath = List.of("translations", locale.toString(), "fields", "content", "editors", contentEditor);
            return this.entityChannelStore.getChannel((EntityReference)documentReference, contentChannelPath).map(contentChannel -> contentChannel.getUserCount() > 0).orElse(false);
        }
        if (INLINE.equals(editMode)) {
            // empty if block
        }
        return false;
    }

    String getEditMode() {
        String requestEditor = (String)this.container.getRequest().getParameter(EDITOR_KEY);
        if (!StringUtils.isEmpty((CharSequence)requestEditor)) {
            return requestEditor;
        }
        String scontextEditor = (String)this.scriptContextManager.getCurrentScriptContext().getAttribute(EDITOR_KEY);
        if (!StringUtils.isEmpty((CharSequence)scontextEditor)) {
            return scontextEditor;
        }
        XWikiContext context = (XWikiContext)this.xwikiContextProvider.get();
        XWikiDocument document = (XWikiDocument)context.get((Object)"tdoc");
        if (!this.sheetManager.getSheets((DocumentModelBridge)document, context.getAction()).isEmpty()) {
            return INLINE;
        }
        String xwikiEditorPreference = context.getWiki().getEditorPreference(context);
        if (WYSIWYG.equals(xwikiEditorPreference) && ((WysiwygEditorScriptService)this.wysiwygEditorScriptService).isSyntaxSupported(document.getSyntax().toIdString())) {
            return xwikiEditorPreference;
        }
        return WIKI;
    }
}

