/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal.rest;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.netflux.EntityChannel;
import org.xwiki.netflux.EntityChannelStore;
import org.xwiki.netflux.rest.PageChannelsResource;
import org.xwiki.netflux.rest.model.jaxb.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.netflux.internal.rest.DefaultPageChannelsResource")
public class DefaultPageChannelsResource
extends XWikiResource
implements PageChannelsResource {
    private static final String PATH_SEPARATOR = "/";
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private EntityChannelStore channelStore;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    @Override
    public List<org.xwiki.netflux.rest.model.jaxb.EntityChannel> getChannels(String wikiName, String spaceNames, String pageName, List<String> paths, Boolean create) throws XWikiRestException {
        DocumentReference documentReference = new DocumentReference(pageName, this.getSpaceReference(spaceNames, wikiName));
        if (!this.authorization.hasAccess(Right.EDIT, (org.xwiki.model.reference.EntityReference)documentReference)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<String> actualPaths = paths.stream().filter(Objects::nonNull).toList();
        return this.getChannels((org.xwiki.model.reference.EntityReference)documentReference, actualPaths, (boolean)create).stream().map(this::toRestChannel).toList();
    }

    private List<EntityChannel> getChannels(org.xwiki.model.reference.EntityReference entityReference, List<String> paths, boolean create) {
        if (paths.isEmpty()) {
            return this.channelStore.getChannels(entityReference);
        }
        return paths.stream().flatMap(path -> this.getChannels(entityReference, (String)path, create)).toList();
    }

    private Stream<EntityChannel> getChannels(org.xwiki.model.reference.EntityReference entityReference, String path, boolean create) {
        List<String> pathElements = this.decodePath(path);
        if (path.endsWith(PATH_SEPARATOR)) {
            return this.channelStore.getChannels(entityReference, pathElements).stream();
        }
        Optional channel = this.channelStore.getChannel(entityReference, pathElements);
        if (channel.isPresent()) {
            return channel.map(Stream::of).orElseGet(Stream::empty);
        }
        if (create && !path.isEmpty()) {
            return Stream.of(this.channelStore.createChannel(entityReference, pathElements));
        }
        return Stream.empty();
    }

    private List<String> decodePath(String path) {
        return Stream.of(path.split(PATH_SEPARATOR)).map(pathElement -> {
            try {
                return URLDecoder.decode(pathElement, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return pathElement;
            }
        }).toList();
    }

    private org.xwiki.netflux.rest.model.jaxb.EntityChannel toRestChannel(EntityChannel channel) {
        String entityReferenceString = (String)this.entityReferenceSerializer.serialize(channel.getEntityReference(), new Object[0]);
        EntityReference entityReference = new EntityReference().withType(channel.getEntityReference().getType().name()).withValue(entityReferenceString);
        return new org.xwiki.netflux.rest.model.jaxb.EntityChannel().withEntityReference(entityReference).withPath(channel.getPath()).withKey(channel.getKey()).withUserCount(channel.getUserCount());
    }
}

