/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.netflux.EntityChannel;
import org.xwiki.netflux.EntityChannelStore;
import org.xwiki.netflux.internal.EntityChange;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.UserReferenceSerializer;

@Component(roles={EntityChannelScriptAuthorTracker.class})
@Singleton
public class EntityChannelScriptAuthorTracker {
    @Inject
    private Logger logger;
    @Inject
    private EntityChannelStore entityChannels;
    @Inject
    private DocumentAuthorizationManager authorizationManager;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> documentUserReferenceSerializer;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserResolver;
    @Inject
    @Named(value="explicit")
    private EntityReferenceResolver<String> explicitEntityReferenceResolver;
    private final Map<String, EntityChange> scriptAuthors = new ConcurrentHashMap<String, EntityChange>();

    public Optional<EntityChange> getScriptAuthor(String channelId) {
        Optional<EntityChange> returnValue = Optional.empty();
        EntityChange channelScriptAuthor = this.scriptAuthors.get(channelId);
        if (channelScriptAuthor != null) {
            UserReference currentUserReference = this.currentUserResolver.resolve((Object)CurrentUserReference.INSTANCE, new Object[0]);
            EntityChange.ScriptLevel currentUserScriptLevel = this.getUserScriptLevel(currentUserReference, channelScriptAuthor.getEntityReference());
            if (currentUserScriptLevel.compareTo(channelScriptAuthor.getScriptLevel()) > 0) {
                this.logger.debug("The script author associated with the entity channel [{}] is [{}].", (Object)channelId, (Object)channelScriptAuthor);
                returnValue = Optional.of(channelScriptAuthor);
            }
            if (this.entityChannels.getChannel(channelId).isEmpty()) {
                this.scriptAuthors.remove(channelId);
            }
        }
        return returnValue;
    }

    void maybeUpdateScriptAuthor(EntityChannel entityChannel, UserReference scriptAuthor) {
        EntityChange channelScriptAuthor = this.scriptAuthors.get(entityChannel.getKey());
        EntityChange.ScriptLevel userScriptLevel = this.getUserScriptLevel(scriptAuthor, entityChannel.getEntityReference());
        if (channelScriptAuthor == null || userScriptLevel.compareTo(channelScriptAuthor.getScriptLevel()) <= 0) {
            EntityChange scriptAuthorChange = new EntityChange(entityChannel.getEntityReference(), scriptAuthor, userScriptLevel);
            this.scriptAuthors.put(entityChannel.getKey(), scriptAuthorChange);
            this.logger.debug("Updated the script author associated with the entity channel [{}] to [{}].", (Object)entityChannel, (Object)scriptAuthorChange);
        }
    }

    private EntityChange.ScriptLevel getUserScriptLevel(UserReference userReference, EntityReference entityReference) {
        DocumentReference documentUserReference = (DocumentReference)this.documentUserReferenceSerializer.serialize(userReference);
        EntityReference documentEntityReference = entityReference.extractReference(EntityType.DOCUMENT);
        if (documentEntityReference != null) {
            DocumentReference documentReference = new DocumentReference(documentEntityReference);
            if (this.authorizationManager.hasAccess(Right.PROGRAM, null, documentUserReference, documentReference)) {
                return EntityChange.ScriptLevel.PROGRAMMING;
            }
            if (this.authorizationManager.hasAccess(Right.SCRIPT, EntityType.DOCUMENT, documentUserReference, documentReference)) {
                return EntityChange.ScriptLevel.SCRIPT;
            }
            return EntityChange.ScriptLevel.NO_SCRIPT;
        }
        return EntityChange.ScriptLevel.NO_SCRIPT;
    }
}

