/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.netflux.EntityChannel;
import org.xwiki.netflux.EntityChannelStore;
import org.xwiki.netflux.internal.AbstractBot;
import org.xwiki.netflux.internal.Channel;
import org.xwiki.netflux.internal.EntityChannelScriptAuthorTracker;
import org.xwiki.netflux.internal.User;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.websocket.WebSocketContext;

@Component
@Singleton
@Named(value="EntityChannelScriptAuthorBot")
public class EntityChannelScriptAuthorBot
extends AbstractBot {
    private static final List<String> PROTECTED_CHANNELS = List.of("wysiwyg", "wiki");
    @Inject
    private Logger logger;
    @Inject
    private EntityChannelStore entityChannels;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserResolver;
    @Inject
    private WebSocketContext webSocketContext;
    @Inject
    private EntityChannelScriptAuthorTracker scriptAuthorTracker;

    public boolean onJoinChannel(Channel channel) {
        Optional<EntityChannel> entityChannel = this.entityChannels.getChannel(channel.getKey());
        boolean accept = entityChannel.map(this::needsProtection).orElse(false);
        if (accept) {
            this.logger.debug("Joining channel [{}].", (Object)entityChannel.get());
        }
        return accept;
    }

    public void onChannelMessage(Channel channel, User sender, String messageType, String message) {
        if ("MSG".equals(messageType)) {
            this.entityChannels.getChannel(channel.getKey()).ifPresent(entityChannel -> this.webSocketContext.run(sender.getSession(), () -> {
                UserReference senderUserReference = this.currentUserResolver.resolve((Object)CurrentUserReference.INSTANCE, new Object[0]);
                this.scriptAuthorTracker.maybeUpdateScriptAuthor((EntityChannel)entityChannel, senderUserReference);
            }));
        }
    }

    private boolean needsProtection(EntityChannel entityChannel) {
        List<String> path = entityChannel.getPath();
        return !path.isEmpty() && PROTECTED_CHANNELS.contains(path.get(path.size() - 1));
    }
}

