/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.text.XWikiToStringBuilder;
import org.xwiki.user.UserReference;

public class EntityChange
implements Comparable<EntityChange> {
    private final EntityReference entityReference;
    private final UserReference author;
    private final ScriptLevel scriptLevel;
    private final long timestamp = new Date().getTime();

    public EntityChange(EntityReference entityReference, UserReference author, ScriptLevel scriptLevel) {
        this.entityReference = entityReference;
        this.author = author;
        this.scriptLevel = scriptLevel;
    }

    public EntityReference getEntityReference() {
        return this.entityReference;
    }

    public UserReference getAuthor() {
        return this.author;
    }

    public ScriptLevel getScriptLevel() {
        return this.scriptLevel;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.entityReference).append((Object)this.author).append((Object)this.scriptLevel).append(this.timestamp).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        EntityChange otherChange = (EntityChange)object;
        return new EqualsBuilder().append((Object)this.entityReference, (Object)otherChange.entityReference).append((Object)this.author, (Object)otherChange.author).append((Object)this.scriptLevel, (Object)otherChange.scriptLevel).append(this.timestamp, otherChange.timestamp).isEquals();
    }

    @Override
    public int compareTo(EntityChange other) {
        int scriptLevelDifference = this.scriptLevel.compareTo(other.scriptLevel);
        return scriptLevelDifference != 0 ? scriptLevelDifference : Long.compare(other.timestamp, this.timestamp);
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("entity", (Object)this.entityReference).append("author", (Object)this.author).append("scriptLevel", (Object)this.scriptLevel).append("timestamp", this.timestamp).toString();
    }

    public static enum ScriptLevel {
        NO_SCRIPT,
        SCRIPT,
        PROGRAMMING;

    }
}

