/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ActionExecutingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.netflux.internal.EntityChange;
import org.xwiki.netflux.internal.EntityChannelScriptAuthorTracker;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.user.UserReference;

@Component
@Singleton
@Named(value="org.xwiki.netflux.internal.EffectiveAuthorSetterListener")
public class EffectiveAuthorSetterListener
extends AbstractLocalEventListener {
    public static final String HINT = "org.xwiki.netflux.internal.EffectiveAuthorSetterListener";
    @Inject
    private Logger logger;
    @Inject
    private EntityChannelScriptAuthorTracker scriptAuthorTracker;
    @Inject
    private Container container;

    public EffectiveAuthorSetterListener() {
        super(HINT, new Event[]{new ActionExecutingEvent()});
    }

    public void processLocalEvent(Event event, Object source, Object data) {
        Request request = this.container.getRequest();
        this.getEffectiveAuthor(request).ifPresent(effectiveAuthor -> {
            this.logger.debug("Setting the effective author of the request to [{}].", effectiveAuthor);
            request.setAttribute(Request.ATTRIBUTE_EFFECTIVE_AUTHOR, effectiveAuthor);
        });
    }

    private Optional<UserReference> getEffectiveAuthor(Request request) {
        return this.getChannelsFromRequest(request).stream().map(channel -> this.scriptAuthorTracker.getScriptAuthor((String)channel)).filter(Optional::isPresent).map(Optional::get).sorted().map(EntityChange::getAuthor).findFirst();
    }

    private List<String> getChannelsFromRequest(Request request) {
        String[] values = request.getParameterValues("netfluxChannel");
        Stream<Object> valuesStream = values == null ? Stream.empty() : Arrays.stream(values);
        List<String> channels = valuesStream.filter(StringUtils::isNotBlank).toList();
        this.logger.debug("Channels from request: [{}].", channels);
        return channels;
    }
}

