/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.like.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.like.events.LikeEvent;
import org.xwiki.like.events.LikeRecordableEvent;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.RemoteObservationManagerContext;

@Component
@Singleton
@Named(value="LikeEventListener")
public class LikeEventListener
extends AbstractEventListener {
    public static final String NAME = "LikeEventListener";
    private static final List<Event> EVENT_LIST = Collections.singletonList(new LikeEvent());
    @Inject
    private ObservationManager observationManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private Logger logger;
    @Inject
    private RemoteObservationManagerContext remoteObservationManagerContext;

    public LikeEventListener() {
        super(NAME, EVENT_LIST);
    }

    public void onEvent(Event event, Object source, Object data) {
        if (data != null && !this.remoteObservationManagerContext.isRemoteState()) {
            EntityReference likedEntity = (EntityReference)data;
            try {
                DocumentModelBridge documentInstance = this.documentAccessBridge.getDocumentInstance(likedEntity);
                this.observationManager.notify((Event)new LikeRecordableEvent(), (Object)"org.xwiki.platform:xwiki-platform-like-notifications", (Object)documentInstance);
            }
            catch (Exception e) {
                this.logger.error("Error while sending event about like on [{}]", (Object)likedEntity, (Object)e);
            }
        }
    }
}

