/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.like.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheEntry;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.cache.event.CacheEntryEvent;
import org.xwiki.cache.event.CacheEntryListener;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.like.LikeConfiguration;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component(roles={LikeManagerCacheHelper.class})
@Singleton
public class LikeManagerCacheHelper
implements Initializable,
Disposable {
    @Inject
    private CacheManager cacheManager;
    @Inject
    private LikeConfiguration likeConfiguration;
    @Inject
    private UserReferenceSerializer<String> userReferenceStringSerializer;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    private Cache<Long> likeCountCache;
    private Cache<Pair<EntityReference, Boolean>> likeExistCache;
    private LikeExistCacheEntryListener likeExistCacheEntryListener;

    public void initialize() throws InitializationException {
        int likeCacheCapacity = this.likeConfiguration.getLikeCacheCapacity();
        try {
            this.likeCountCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("xwiki.like.count.cache", likeCacheCapacity));
            this.likeExistCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("xwiki.like.exist.cache", likeCacheCapacity));
            this.likeExistCacheEntryListener = new LikeExistCacheEntryListener();
            this.likeExistCache.addCacheEntryListener((CacheEntryListener)this.likeExistCacheEntryListener);
        }
        catch (CacheException e) {
            throw new InitializationException("Error while creating the cache for likes.", (Throwable)e);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        this.likeExistCache.dispose();
        this.likeCountCache.dispose();
    }

    private String getExistCacheKey(UserReference source, EntityReference target) {
        return String.format("%s_%s", this.userReferenceStringSerializer.serialize(source), this.entityReferenceSerializer.serialize(target, new Object[0]));
    }

    public void removeCount(EntityReference target) {
        this.likeCountCache.remove((String)this.entityReferenceSerializer.serialize(target, new Object[0]));
    }

    public void setExist(UserReference source, EntityReference target, boolean value) {
        this.likeExistCache.set(this.getExistCacheKey(source, target), (Object)Pair.of((Object)target, (Object)value));
    }

    public Boolean isExist(UserReference source, EntityReference target) {
        Boolean result = null;
        Pair cacheEntry = (Pair)this.likeExistCache.get(this.getExistCacheKey(source, target));
        if (cacheEntry != null) {
            result = (Boolean)cacheEntry.getRight();
        }
        return result;
    }

    public Long getCount(EntityReference target) {
        return (Long)this.likeCountCache.get((String)this.entityReferenceSerializer.serialize(target, new Object[0]));
    }

    public void setCount(EntityReference target, Long value) {
        this.likeCountCache.set((String)this.entityReferenceSerializer.serialize(target, new Object[0]), (Object)value);
    }

    public void clearCache(EntityReference target) {
        this.likeCountCache.remove((String)this.entityReferenceSerializer.serialize(target, new Object[0]));
        ArrayList impactedKeys = new ArrayList(this.likeExistCacheEntryListener.getReferenceKeyMapping().getOrDefault(target, Collections.emptyList()));
        for (String impactedKey : impactedKeys) {
            this.likeExistCache.remove(impactedKey);
        }
    }

    public void clearCache() {
        this.likeCountCache.removeAll();
        this.likeExistCache.removeAll();
    }

    static class LikeExistCacheEntryListener
    implements CacheEntryListener<Pair<EntityReference, Boolean>> {
        private final Map<EntityReference, List<String>> referenceKeyMapping = new ConcurrentHashMap<EntityReference, List<String>>();

        LikeExistCacheEntryListener() {
        }

        public void cacheEntryAdded(CacheEntryEvent<Pair<EntityReference, Boolean>> event) {
            CacheEntry entry = event.getEntry();
            String key = entry.getKey();
            EntityReference entityReference = (EntityReference)((Pair)entry.getValue()).getLeft();
            if (this.referenceKeyMapping.containsKey(entityReference)) {
                List<String> keyList = this.referenceKeyMapping.get(entityReference);
                keyList.add(key);
            } else {
                ArrayList<String> keyList = new ArrayList<String>();
                keyList.add(key);
                this.referenceKeyMapping.put(entityReference, keyList);
            }
        }

        public void cacheEntryRemoved(CacheEntryEvent<Pair<EntityReference, Boolean>> event) {
            CacheEntry entry = event.getEntry();
            String key = entry.getKey();
            EntityReference entityReference = (EntityReference)((Pair)entry.getValue()).getLeft();
            if (this.referenceKeyMapping.containsKey(entityReference)) {
                List<String> keyList = this.referenceKeyMapping.get(entityReference);
                keyList.remove(key);
                if (keyList.isEmpty()) {
                    this.referenceKeyMapping.remove(entityReference);
                }
            }
        }

        public void cacheEntryModified(CacheEntryEvent<Pair<EntityReference, Boolean>> event) {
        }

        public Map<EntityReference, List<String>> getReferenceKeyMapping() {
            return this.referenceKeyMapping;
        }
    }
}

