/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.like.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.like.LikeException;
import org.xwiki.like.LikeManager;
import org.xwiki.like.events.LikeEvent;
import org.xwiki.like.events.UnlikeEvent;
import org.xwiki.like.internal.LikeManagerCacheHelper;
import org.xwiki.like.internal.LikeRight;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.ratings.Rating;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.RatingsManagerFactory;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightDescription;
import org.xwiki.security.authorization.UnableToRegisterRightException;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Singleton
public class DefaultLikeManager
implements LikeManager,
Initializable,
Disposable {
    private static final int DEFAULT_LIKE_VOTE = 1;
    @Inject
    private RatingsManagerFactory ratingsManagerFactory;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> userReferenceDocumentSerializer;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private EntityReferenceFactory entityReferenceFactory;
    @Inject
    private LikeManagerCacheHelper likeManagerCacheHelper;
    private RatingsManager ratingsManager;
    private Right likeRight;

    public void initialize() throws InitializationException {
        try {
            this.likeRight = this.authorizationManager.register((RightDescription)LikeRight.INSTANCE);
        }
        catch (UnableToRegisterRightException e) {
            throw new InitializationException("Error while registering the Like right.", (Throwable)e);
        }
        try {
            this.ratingsManager = this.ratingsManagerFactory.getRatingsManager("like");
        }
        catch (RatingsException e) {
            throw new InitializationException("Error while trying to get the RatingManager.", (Throwable)e);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        try {
            this.authorizationManager.unregister(this.likeRight);
        }
        catch (AuthorizationException e) {
            throw new ComponentLifecycleException("Error while unregistering like right", (Throwable)e);
        }
    }

    @Override
    public long saveLike(UserReference source, EntityReference target) throws LikeException {
        DocumentReference userDoc = (DocumentReference)this.userReferenceDocumentSerializer.serialize(source);
        if (this.authorizationManager.hasAccess(this.likeRight, userDoc, target)) {
            try {
                EntityReference dedupTarget = this.entityReferenceFactory.getReference(target);
                this.ratingsManager.saveRating(dedupTarget, source, 1);
                this.likeManagerCacheHelper.removeCount(dedupTarget);
                this.likeManagerCacheHelper.setExist(source, dedupTarget, true);
                long newCount = this.getEntityLikes(dedupTarget);
                this.observationManager.notify((Event)new LikeEvent(), (Object)source, (Object)dedupTarget);
                return newCount;
            }
            catch (RatingsException e) {
                throw new LikeException(String.format("Error while liking entity [%s]", target), e);
            }
        }
        throw new LikeException(String.format("User [%s] is not authorized to perform a like on [%s]", source, target));
    }

    @Override
    public List<EntityReference> getUserLikes(UserReference source, int offset, int limit) throws LikeException {
        try {
            List ratings = this.ratingsManager.getRatings(Collections.singletonMap(RatingsManager.RatingQueryField.USER_REFERENCE, source), offset, limit, RatingsManager.RatingQueryField.UPDATED_DATE, false);
            return ratings.stream().map(Rating::getReference).toList();
        }
        catch (RatingsException e) {
            throw new LikeException(String.format("Error when trying to retrieve user likes for user [%s]", source), e);
        }
    }

    @Override
    public long countUserLikes(UserReference source) throws LikeException {
        try {
            return this.ratingsManager.countRatings(Collections.singletonMap(RatingsManager.RatingQueryField.USER_REFERENCE, source));
        }
        catch (RatingsException e) {
            throw new LikeException(String.format("Error when trying to count user likes for user [%s]", source), e);
        }
    }

    @Override
    public long getEntityLikes(EntityReference target) throws LikeException {
        Long result = this.likeManagerCacheHelper.getCount(target);
        if (result == null) {
            LinkedHashMap<RatingsManager.RatingQueryField, EntityReference> queryMap = new LinkedHashMap<RatingsManager.RatingQueryField, EntityReference>();
            queryMap.put(RatingsManager.RatingQueryField.ENTITY_REFERENCE, target);
            try {
                result = this.ratingsManager.countRatings(queryMap);
                this.likeManagerCacheHelper.setCount(target, result);
            }
            catch (RatingsException e) {
                throw new LikeException(String.format("Error while getting ratings for entity [%s]", target), e);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean removeLike(UserReference source, EntityReference target) throws LikeException {
        DocumentReference userDoc = (DocumentReference)this.userReferenceDocumentSerializer.serialize(source);
        boolean result = false;
        if (!this.authorizationManager.hasAccess(this.getLikeRight(), userDoc, target)) throw new LikeException(String.format("User [%s] is not authorized to remove a like on [%s].", userDoc, target));
        EntityReference dedupTarget = this.entityReferenceFactory.getReference(target);
        LinkedHashMap<RatingsManager.RatingQueryField, Object> queryMap = new LinkedHashMap<RatingsManager.RatingQueryField, Object>();
        queryMap.put(RatingsManager.RatingQueryField.ENTITY_REFERENCE, dedupTarget);
        queryMap.put(RatingsManager.RatingQueryField.USER_REFERENCE, source);
        try {
            List ratings = this.ratingsManager.getRatings(queryMap, 0, 1, RatingsManager.RatingQueryField.UPDATED_DATE, false);
            if (ratings.isEmpty()) return result;
            result = this.ratingsManager.removeRating(((Rating)ratings.get(0)).getId());
            this.likeManagerCacheHelper.removeCount(dedupTarget);
            this.likeManagerCacheHelper.setExist(source, dedupTarget, false);
            this.observationManager.notify((Event)new UnlikeEvent(), (Object)source, (Object)dedupTarget);
            return result;
        }
        catch (RatingsException e) {
            throw new LikeException("Error while removing rating", e);
        }
    }

    @Override
    public boolean isLiked(UserReference source, EntityReference target) throws LikeException {
        Boolean result = this.likeManagerCacheHelper.isExist(source, target);
        if (result == null) {
            EntityReference dedupTarget = this.entityReferenceFactory.getReference(target);
            LinkedHashMap<RatingsManager.RatingQueryField, Object> queryMap = new LinkedHashMap<RatingsManager.RatingQueryField, Object>();
            queryMap.put(RatingsManager.RatingQueryField.ENTITY_REFERENCE, dedupTarget);
            queryMap.put(RatingsManager.RatingQueryField.USER_REFERENCE, source);
            try {
                List ratings = this.ratingsManager.getRatings(queryMap, 0, 1, RatingsManager.RatingQueryField.UPDATED_DATE, false);
                result = !ratings.isEmpty();
                this.likeManagerCacheHelper.setExist(source, dedupTarget, result);
            }
            catch (RatingsException e) {
                throw new LikeException("Error while checking if rating exists", e);
            }
        }
        return result;
    }

    @Override
    public List<UserReference> getLikers(EntityReference target, int offset, int limit) throws LikeException {
        LinkedHashMap<RatingsManager.RatingQueryField, EntityReference> queryMap = new LinkedHashMap<RatingsManager.RatingQueryField, EntityReference>();
        queryMap.put(RatingsManager.RatingQueryField.ENTITY_REFERENCE, target);
        try {
            List ratings = this.ratingsManager.getRatings(queryMap, offset, limit, RatingsManager.RatingQueryField.UPDATED_DATE, false);
            return ratings.stream().map(Rating::getAuthor).toList();
        }
        catch (RatingsException e) {
            throw new LikeException(String.format("Error while getting likers of [%s]", target), e);
        }
    }

    @Override
    public Right getLikeRight() {
        return this.likeRight;
    }

    @Override
    public void clearCache(EntityReference target) {
        this.likeManagerCacheHelper.clearCache(target);
    }

    @Override
    public void clearCache() {
        this.likeManagerCacheHelper.clearCache();
    }
}

