/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.like.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.like.LikeManager;
import org.xwiki.like.events.LikeEvent;
import org.xwiki.like.events.UnlikeEvent;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.async.internal.AsyncRendererCache;

@Component
@Named(value="CacheHandlingLikeEventsListener")
@Singleton
@Priority(value=100)
public class CacheHandlingLikeEventsListener
extends AbstractEventListener {
    static final String NAME = "CacheHandlingLikeEventsListener";
    private static final List<Event> EVENT_LIST = Arrays.asList(new LikeEvent(), new UnlikeEvent());
    private static final LocalDocumentReference UIX_REFERENCE = new LocalDocumentReference((EntityReference)new LocalDocumentReference(Arrays.asList("XWiki", "Like"), "LikeUIX"), Locale.ROOT);
    @Inject
    private Provider<AsyncRendererCache> asyncRendererCacheProvider;
    @Inject
    private Provider<LikeManager> likeManagerProvider;

    public CacheHandlingLikeEventsListener() {
        super(NAME, EVENT_LIST);
    }

    private void cleanCacheUIX(WikiReference wikiReference) {
        DocumentReference localUIXReference = new DocumentReference(UIX_REFERENCE, wikiReference);
        ((AsyncRendererCache)this.asyncRendererCacheProvider.get()).cleanCache((EntityReference)localUIXReference);
    }

    public void onEvent(Event event, Object source, Object data) {
        if (data instanceof EntityReference) {
            EntityReference target = (EntityReference)data;
            ((LikeManager)this.likeManagerProvider.get()).clearCache(target);
            this.cleanCacheUIX((WikiReference)target.extractReference(EntityType.WIKI));
        }
    }
}

