/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.image.style.internal.rendering;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.xwiki.image.style.internal.rendering.AbstractCaptionedImageChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;

class CaptionedImageRenderChainingListener
extends AbstractCaptionedImageChainingListener {
    static final Set<String> KNOWN_PARAMETERS = Set.of("width", "style", "data-xwiki-image-style", "data-xwiki-image-style-alignment", "data-xwiki-image-style-border", "data-xwiki-image-style-text-wrap");

    protected CaptionedImageRenderChainingListener(ListenerChain listenerChain) {
        super(listenerChain);
    }

    @Override
    protected Map<String, String> updateFigureParameters(Map<String, String> figureParameters, Map<String, String> imageParameters) {
        LinkedHashMap<String, String> updatedFigureParameters = new LinkedHashMap<String, String>(figureParameters);
        KNOWN_PARAMETERS.forEach(key -> {
            if (key.equals("style") && updatedFigureParameters.containsKey("style") && imageParameters.containsKey("width")) {
                String figureStyle = (String)updatedFigureParameters.get("style");
                String cleanupStyle = Arrays.stream(figureStyle.split(";")).filter(Predicate.not(value -> Objects.equals(value.trim(), String.format("width: %spx", imageParameters.get("width"))))).collect(Collectors.joining(";", "", ";"));
                if (cleanupStyle.equals(";")) {
                    cleanupStyle = "";
                }
                if (cleanupStyle.isEmpty()) {
                    updatedFigureParameters.remove(key);
                } else {
                    updatedFigureParameters.put((String)key, cleanupStyle);
                }
            } else if (!key.equals("style")) {
                updatedFigureParameters.remove(key);
            }
        });
        return updatedFigureParameters;
    }
}

