/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.image.style.internal.rendering;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.xwiki.image.style.internal.rendering.AbstractCaptionedImageChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;

class CaptionedImageParseChainingListener
extends AbstractCaptionedImageChainingListener {
    private static final Set<String> KNOWN_PARAMETERS = Set.of("width", "data-xwiki-image-style", "data-xwiki-image-style-alignment", "data-xwiki-image-style-border", "data-xwiki-image-style-text-wrap");

    protected CaptionedImageParseChainingListener(ListenerChain listenerChain) {
        super(listenerChain);
    }

    @Override
    protected Map<String, String> updateFigureParameters(Map<String, String> figureParameters, Map<String, String> imageParameters) {
        LinkedHashMap<String, String> mergedMap = new LinkedHashMap<String, String>(figureParameters);
        KNOWN_PARAMETERS.stream().filter(imageParameters::containsKey).forEach(key -> this.mergeParameter((String)key, (Map<String, String>)mergedMap, imageParameters, figureParameters));
        return mergedMap;
    }

    private void mergeParameter(String key, Map<String, String> mergedMap, Map<String, String> imageParameters, Map<String, String> figureParameters) {
        String imageParameter = imageParameters.get(key);
        if (Objects.equals(key, "width")) {
            this.mergeWidthParameter(mergedMap, figureParameters, imageParameters.get("width"));
        } else {
            mergedMap.put(key, imageParameter);
        }
    }

    private void mergeWidthParameter(Map<String, String> mergedMap, Map<String, String> figureParameters, String imageWidthParameter) {
        Object styleValue = String.format("width: %spx;", imageWidthParameter);
        if (figureParameters.containsKey("style")) {
            if (figureParameters.get("style").contains("width:")) {
                styleValue = figureParameters.get("style");
            } else {
                styleValue = !figureParameters.get("style").endsWith(";") ? "; " + (String)styleValue : " " + (String)styleValue;
                styleValue = figureParameters.get("style") + (String)styleValue;
            }
        }
        mergedMap.put("style", (String)styleValue);
    }
}

