import { elementNodeType } from "./types";
export declare class Diff {
    constructor(options?: {});
    toString(): string;
    setValue(aKey: string | number, aValue: string | number | boolean | number[] | {
        [key: string]: string | {
            [key: string]: string;
        };
    } | elementNodeType): this;
}
/**
 * Checks if an element is of a certain type using direct property checking or DOM instanceof
 *
 * @param element The element to check
 * @param elementTypeNames The element type names to check against
 * @param simplifiedCheck If true, uses simplified checking based on nodeName/nodeType
 * @returns boolean indicating if the element matches any of the specified types
 */
export declare function checkElementType(element: any, simplifiedCheck?: boolean, ...elementTypeNames: string[]): boolean;
