/*
 * Decompiled with CFR 0.152.
 */
package com.github.kklisura.cdt.services.impl;

import com.github.kklisura.cdt.services.WebSocketService;
import com.github.kklisura.cdt.services.exceptions.WebSocketServiceException;
import com.github.kklisura.cdt.services.factory.WebSocketContainerFactory;
import com.github.kklisura.cdt.services.factory.impl.DefaultWebSocketContainerFactory;
import com.github.kklisura.cdt.services.impl.utils.WebSocketUtils;
import com.github.kklisura.cdt.services.utils.ConfigurationUtils;
import java.io.IOException;
import java.net.URI;
import java.util.function.Consumer;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServiceImpl
implements WebSocketService {
    public static final String WEB_SOCKET_CONTAINER_FACTORY_PROPERTY = "com.github.kklisura.cdt.services.config.webSocketContainerFactory";
    private static final String DEFAULT_WEB_SOCKET_CONTAINER_FACTORY = DefaultWebSocketContainerFactory.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketServiceImpl.class);
    private static final WebSocketContainer WEB_SOCKET_CONTAINER = WebSocketServiceImpl.getWebSocketContainer();
    private Session session;

    public WebSocketServiceImpl(Session session) {
        this.session = session;
    }

    private WebSocketServiceImpl() {
    }

    public static WebSocketService create(URI uri) throws WebSocketServiceException {
        WebSocketServiceImpl webSocketService = new WebSocketServiceImpl();
        webSocketService.connect(uri);
        return webSocketService;
    }

    @Override
    public void connect(URI uri) throws WebSocketServiceException {
        LOGGER.debug("Connecting to ws server {}", (Object)uri);
        final WebSocketServiceImpl webSocketService = this;
        try {
            this.session = WEB_SOCKET_CONTAINER.connectToServer((Object)new Endpoint(){

                public void onOpen(Session session, EndpointConfig config) {
                    webSocketService.onOpen(session, config);
                }

                public void onClose(Session session, CloseReason closeReason) {
                    super.onClose(session, closeReason);
                    webSocketService.onClose(session, closeReason);
                }

                public void onError(Session session, Throwable thr) {
                    super.onError(session, thr);
                    webSocketService.onError(session, thr);
                }
            }, uri);
        }
        catch (IOException | DeploymentException e) {
            LOGGER.warn("Failed connecting to ws server {}...", (Object)uri, (Object)e);
            throw new WebSocketServiceException("Failed connecting to ws server {}", e);
        }
    }

    @Override
    public void send(String message) throws WebSocketServiceException {
        try {
            LOGGER.debug("Sending message {} on {}", (Object)message, (Object)this.session.getRequestURI());
            this.session.getBasicRemote().sendText(message);
        }
        catch (Exception e) {
            LOGGER.error("Failed sending data to ws server {}...", (Object)this.session.getRequestURI(), (Object)e);
            throw new WebSocketServiceException("Failed sending data to ws server.", e);
        }
    }

    @Override
    public void addMessageHandler(final Consumer<String> consumer) throws WebSocketServiceException {
        if (this.session == null) {
            throw new WebSocketServiceException("You first must connect to ws server in order to receive messages.");
        }
        if (!this.session.getMessageHandlers().isEmpty()) {
            throw new WebSocketServiceException("You are already subscribed to this web socket service.");
        }
        this.session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                LOGGER.debug("Received message {} on {}", (Object)message, (Object)WebSocketServiceImpl.this.session.getRequestURI());
                consumer.accept(message);
            }
        });
    }

    @Override
    public void close() {
        try {
            this.session.close();
            this.session = null;
        }
        catch (IOException e) {
            LOGGER.error("Failed closing ws session on {}...", (Object)this.session.getRequestURI(), (Object)e);
        }
    }

    @Override
    public boolean closed() {
        return this.session == null || !this.session.isOpen();
    }

    private void onOpen(Session session, EndpointConfig config) {
        LOGGER.info("Connected to ws {}", (Object)session.getRequestURI());
    }

    private void onClose(Session session, CloseReason closeReason) {
        LOGGER.info("Web socket connection closed {}, {}", (Object)closeReason.getCloseCode(), (Object)closeReason.getReasonPhrase());
        if (WebSocketUtils.isTyrusBufferOverflowCloseReason(closeReason)) {
            LOGGER.error("Web socket connection closed due to BufferOverflow raised by Tyrus client. This indicates the message about to be received is larger than the incoming buffer in Tyrus client. See DefaultWebSocketContainerFactory class source on how to increase the incoming buffer size in Tyrus or visit https://github.com/kklisura/chrome-devtools-java-client/blob/master/cdt-examples/src/main/java/com/github/kklisura/cdt/examples/IncreasedIncomingBufferInTyrusExample.java");
        }
    }

    private void onError(Session session, Throwable thr) {
        LOGGER.error("Error in web socket session.", thr);
    }

    public static WebSocketContainer getWebSocketContainer() {
        String containerFactoryClassName = ConfigurationUtils.systemProperty(WEB_SOCKET_CONTAINER_FACTORY_PROPERTY, DEFAULT_WEB_SOCKET_CONTAINER_FACTORY);
        if (containerFactoryClassName == null || containerFactoryClassName.isEmpty()) {
            throw new RuntimeException("com.github.kklisura.cdt.services.config.webSocketContainerFactory property not set");
        }
        try {
            Class<?> containerFactoryClass = Class.forName(containerFactoryClassName);
            if (WebSocketContainerFactory.class.isAssignableFrom(containerFactoryClass)) {
                WebSocketContainerFactory containerFactory = (WebSocketContainerFactory)containerFactoryClass.newInstance();
                return containerFactory.getWebSocketContainer();
            }
            throw new RuntimeException(containerFactoryClassName + " does not implement com.github.kklisura.cdt.services.factory.WebSocketContainerFactory interface.");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(containerFactoryClassName + " class not found.", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Could not create instance of " + containerFactoryClassName + " class");
        }
    }
}

