/*
 * Decompiled with CFR 0.152.
 */
package com.github.kklisura.cdt.protocol.commands;

import com.github.kklisura.cdt.protocol.events.webauthn.CredentialAdded;
import com.github.kklisura.cdt.protocol.events.webauthn.CredentialAsserted;
import com.github.kklisura.cdt.protocol.events.webauthn.CredentialDeleted;
import com.github.kklisura.cdt.protocol.events.webauthn.CredentialUpdated;
import com.github.kklisura.cdt.protocol.support.annotations.EventName;
import com.github.kklisura.cdt.protocol.support.annotations.Experimental;
import com.github.kklisura.cdt.protocol.support.annotations.Optional;
import com.github.kklisura.cdt.protocol.support.annotations.ParamName;
import com.github.kklisura.cdt.protocol.support.annotations.ReturnTypeParameter;
import com.github.kklisura.cdt.protocol.support.annotations.Returns;
import com.github.kklisura.cdt.protocol.support.types.EventHandler;
import com.github.kklisura.cdt.protocol.support.types.EventListener;
import com.github.kklisura.cdt.protocol.types.webauthn.Credential;
import com.github.kklisura.cdt.protocol.types.webauthn.VirtualAuthenticatorOptions;
import java.util.List;

@Experimental
public interface WebAuthn {
    public void enable();

    public void enable(@Optional @ParamName(value="enableUI") Boolean var1);

    public void disable();

    @Returns(value="authenticatorId")
    public String addVirtualAuthenticator(@ParamName(value="options") VirtualAuthenticatorOptions var1);

    public void setResponseOverrideBits(@ParamName(value="authenticatorId") String var1);

    public void setResponseOverrideBits(@ParamName(value="authenticatorId") String var1, @Optional @ParamName(value="isBogusSignature") Boolean var2, @Optional @ParamName(value="isBadUV") Boolean var3, @Optional @ParamName(value="isBadUP") Boolean var4);

    public void removeVirtualAuthenticator(@ParamName(value="authenticatorId") String var1);

    public void addCredential(@ParamName(value="authenticatorId") String var1, @ParamName(value="credential") Credential var2);

    @Returns(value="credential")
    public Credential getCredential(@ParamName(value="authenticatorId") String var1, @ParamName(value="credentialId") String var2);

    @Returns(value="credentials")
    @ReturnTypeParameter(value={Credential.class})
    public List<Credential> getCredentials(@ParamName(value="authenticatorId") String var1);

    public void removeCredential(@ParamName(value="authenticatorId") String var1, @ParamName(value="credentialId") String var2);

    public void clearCredentials(@ParamName(value="authenticatorId") String var1);

    public void setUserVerified(@ParamName(value="authenticatorId") String var1, @ParamName(value="isUserVerified") Boolean var2);

    public void setAutomaticPresenceSimulation(@ParamName(value="authenticatorId") String var1, @ParamName(value="enabled") Boolean var2);

    public void setCredentialProperties(@ParamName(value="authenticatorId") String var1, @ParamName(value="credentialId") String var2);

    public void setCredentialProperties(@ParamName(value="authenticatorId") String var1, @ParamName(value="credentialId") String var2, @Optional @ParamName(value="backupEligibility") Boolean var3, @Optional @ParamName(value="backupState") Boolean var4);

    @EventName(value="credentialAdded")
    public EventListener onCredentialAdded(EventHandler<CredentialAdded> var1);

    @EventName(value="credentialDeleted")
    public EventListener onCredentialDeleted(EventHandler<CredentialDeleted> var1);

    @EventName(value="credentialUpdated")
    public EventListener onCredentialUpdated(EventHandler<CredentialUpdated> var1);

    @EventName(value="credentialAsserted")
    public EventListener onCredentialAsserted(EventHandler<CredentialAsserted> var1);
}

