/*
 * Decompiled with CFR 0.152.
 */
package com.github.kklisura.cdt.protocol.commands;

import com.github.kklisura.cdt.protocol.events.bluetoothemulation.CharacteristicOperationReceived;
import com.github.kklisura.cdt.protocol.events.bluetoothemulation.DescriptorOperationReceived;
import com.github.kklisura.cdt.protocol.events.bluetoothemulation.GattOperationReceived;
import com.github.kklisura.cdt.protocol.support.annotations.EventName;
import com.github.kklisura.cdt.protocol.support.annotations.Experimental;
import com.github.kklisura.cdt.protocol.support.annotations.Optional;
import com.github.kklisura.cdt.protocol.support.annotations.ParamName;
import com.github.kklisura.cdt.protocol.support.annotations.Returns;
import com.github.kklisura.cdt.protocol.support.types.EventHandler;
import com.github.kklisura.cdt.protocol.support.types.EventListener;
import com.github.kklisura.cdt.protocol.types.bluetoothemulation.CentralState;
import com.github.kklisura.cdt.protocol.types.bluetoothemulation.CharacteristicOperationType;
import com.github.kklisura.cdt.protocol.types.bluetoothemulation.CharacteristicProperties;
import com.github.kklisura.cdt.protocol.types.bluetoothemulation.DescriptorOperationType;
import com.github.kklisura.cdt.protocol.types.bluetoothemulation.GATTOperationType;
import com.github.kklisura.cdt.protocol.types.bluetoothemulation.ManufacturerData;
import com.github.kklisura.cdt.protocol.types.bluetoothemulation.ScanEntry;
import java.util.List;

@Experimental
public interface BluetoothEmulation {
    public void enable(@ParamName(value="state") CentralState var1, @ParamName(value="leSupported") Boolean var2);

    public void setSimulatedCentralState(@ParamName(value="state") CentralState var1);

    public void disable();

    public void simulatePreconnectedPeripheral(@ParamName(value="address") String var1, @ParamName(value="name") String var2, @ParamName(value="manufacturerData") List<ManufacturerData> var3, @ParamName(value="knownServiceUuids") List<String> var4);

    public void simulateAdvertisement(@ParamName(value="entry") ScanEntry var1);

    public void simulateGATTOperationResponse(@ParamName(value="address") String var1, @ParamName(value="type") GATTOperationType var2, @ParamName(value="code") Integer var3);

    public void simulateCharacteristicOperationResponse(@ParamName(value="characteristicId") String var1, @ParamName(value="type") CharacteristicOperationType var2, @ParamName(value="code") Integer var3);

    public void simulateCharacteristicOperationResponse(@ParamName(value="characteristicId") String var1, @ParamName(value="type") CharacteristicOperationType var2, @ParamName(value="code") Integer var3, @Optional @ParamName(value="data") String var4);

    public void simulateDescriptorOperationResponse(@ParamName(value="descriptorId") String var1, @ParamName(value="type") DescriptorOperationType var2, @ParamName(value="code") Integer var3);

    public void simulateDescriptorOperationResponse(@ParamName(value="descriptorId") String var1, @ParamName(value="type") DescriptorOperationType var2, @ParamName(value="code") Integer var3, @Optional @ParamName(value="data") String var4);

    @Returns(value="serviceId")
    public String addService(@ParamName(value="address") String var1, @ParamName(value="serviceUuid") String var2);

    public void removeService(@ParamName(value="serviceId") String var1);

    @Returns(value="characteristicId")
    public String addCharacteristic(@ParamName(value="serviceId") String var1, @ParamName(value="characteristicUuid") String var2, @ParamName(value="properties") CharacteristicProperties var3);

    public void removeCharacteristic(@ParamName(value="characteristicId") String var1);

    @Returns(value="descriptorId")
    public String addDescriptor(@ParamName(value="characteristicId") String var1, @ParamName(value="descriptorUuid") String var2);

    public void removeDescriptor(@ParamName(value="descriptorId") String var1);

    public void simulateGATTDisconnection(@ParamName(value="address") String var1);

    @EventName(value="gattOperationReceived")
    public EventListener onGattOperationReceived(EventHandler<GattOperationReceived> var1);

    @EventName(value="characteristicOperationReceived")
    public EventListener onCharacteristicOperationReceived(EventHandler<CharacteristicOperationReceived> var1);

    @EventName(value="descriptorOperationReceived")
    public EventListener onDescriptorOperationReceived(EventHandler<DescriptorOperationReceived> var1);
}

