/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.github.dockerjava.core.util.FiltersBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ListImagesCmdImpl
extends AbstrDockerCmd<ListImagesCmd, List<Image>>
implements ListImagesCmd {
    private String imageNameFilter;
    private Boolean showAll = false;
    private FiltersBuilder filters = new FiltersBuilder();

    public ListImagesCmdImpl(ListImagesCmd.Exec exec) {
        super(exec);
    }

    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }

    public Boolean hasShowAllEnabled() {
        return this.showAll;
    }

    public ListImagesCmd withShowAll(Boolean showAll) {
        this.showAll = showAll;
        return this;
    }

    public ListImagesCmd withDanglingFilter(Boolean dangling) {
        Objects.requireNonNull(dangling, "dangling have not been specified");
        this.withFilter("dangling", Collections.singletonList(dangling.toString()));
        return this;
    }

    public ListImagesCmd withLabelFilter(String ... labels) {
        Objects.requireNonNull(labels, "labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    public ListImagesCmd withLabelFilter(Map<String, String> labels) {
        Objects.requireNonNull(labels, "labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    public ListImagesCmd withImageNameFilter(String imageNameFilter) {
        Objects.requireNonNull(imageNameFilter, "image name filter not specified");
        this.imageNameFilter = imageNameFilter;
        return this;
    }

    public ListImagesCmd withReferenceFilter(String reference) {
        Objects.requireNonNull(reference, "reference filter not specified");
        this.withFilter("reference", Collections.singletonList(reference));
        return this;
    }

    public ListImagesCmd withFilter(String key, Collection<String> values) {
        Objects.requireNonNull(key, "key not specified");
        Objects.requireNonNull(values, "values not specified");
        this.filters.withFilter(key, values);
        return this;
    }

    public String getImageNameFilter() {
        return this.imageNameFilter;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

